/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xepp.h
 * -----------------------------------------------------------------*/

#ifndef XBX_EPP_H_INCLUDED
#define XBX_EPP_H_INCLUDED

#include <xio.h>

extern bx_handlestype bx_handlearray[];    /*lint !e762 redundant declaration */

/* --------------------------------------------------------------------------
 * These declarations are common to all OS's.  Note that the meaning of 
 * OsHandle is OS-dependent.
 * -------------------------------------------------------------------------- */

  bx_portnumtype BestXOpenParallel(int num);

void BestXCloseParallel(bx_portnumtype portnumber);

  bx_errtype BestXParDeviceConnect(bx_portnumtype OsHandle);
  bx_errtype BestXParCheckConnection(bx_portnumtype OsHandle);
void BestXParReleaseConnection(bx_portnumtype OsHandle);
  bx_errtype BestXParPortTimeoutSet(bx_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts);

/* Default timeouts are defined in bx_io.h */

/* --------------------------------------------------------------------------
 * Parallel port addresses and port data (used by drivers).
 * Note that an EPP 1.9 CARD is required at address LPT_1_ADDR or LPT_2_ADDR !
 * -------------------------------------------------------------------------- */

#define LPT_1_ADDR   0x378
#define LPT_2_ADDR   0x278

/* this is the number of REGISTERS at I/O port #... used for mapping */
#define NUMBER_PORTS 8  

/* and these are the register offsets */
#define LPT_BASE     0
#define LPT_STATUS   1
#define LPT_CONTROL  2
#define LPT_ADDR_EPP 3
#define LPT_DATA_EPP 4

/* Pin numbers shown are for the D connector on the PC. 
 * !Pin## means the inversion of the pin is the register bit.
 * States shown (i.e. 1==) are bit values in the register(s) 
 */

/* status register */
#define LPT_WAIT      (bx_int8)(1 << (7)) /* !Pin11; 1== BestX is busy */
#define LPT_INTR      (bx_int8)(1 << (6)) /*  Pin10; */
#define LPT_RTR       (bx_int8)(1 << (5)) /*  Pin12; 1== BestX is ready-to-receive */
#define LPT_SELECT    (bx_int8)(1 << (4)) /*  Pin13; 0== BestX is connected */
#define LPT_RTS       (bx_int8)(1 << (3)) /* !Pin15; 1== BestX is ready-to-send */

/* control register */
#define LPT_SELECT_IN (unsigned char)(1 << (2)) /*  Pin16; 1== disconnect, 0== connect */


/* --------------------------------------------------------------------------
 * These declarations are not always used (OS-DEPENDENT)
 * -------------------------------------------------------------------------- */

  bx_errtype BestXParBasicRead(
  bx_handletype handle,
  bx_int8ptr pData,
  bx_int32 NumBytes,
  bx_int32 * NumBytesRead);

  bx_errtype BestXParBasicWrite(
  bx_handletype handle,
  bx_int8ptr pData,
  bx_int32 NumBytes,
  bx_int32 * NumBytesWritten);


#endif /* _BX_EPP_H_ */
